/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.steps.tabbed;

import filenet.vw.apps.steps.tabbed.VWTabbedStepPanel;
import filenet.vw.apps.steps.tabbed.images.VWImageLoader;
import filenet.vw.apps.steps.tabbed.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.runtime.step.IVWStepProcessor;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWLoadingWindow;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.ImageIcon;

public class VWTabbedStepApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener,
IVWStepProcessor {
    private VWTabbedStepPanel m_tabbedStepPanel = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(null)) {
                System.exit(1);
            }
            VWTabbedStepApplication pApp = new VWTabbedStepApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            String title = VWIDMBaseFactory.instance().getVWString(8).toString();
            this.setTitle(title);
            ImageIcon icon = VWImageLoader.createImageIcon("step.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("stepproc_location", null)) {
                Dimension dim = VWStringUtils.stringToDimension(VWResource.s_mainWindowDim);
                if (dim == null) {
                    dim = new Dimension(600, 500);
                }
                this.updatePosition(dim.width, dim.height);
            }
            VWLoadingWindow loadingWindow = new VWLoadingWindow((Frame)this, title);
            this.show();
            if (loadingWindow != null) {
                loadingWindow.start(this, 250);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_tabbedStepPanel = new VWTabbedStepPanel();
            this.getContentPane().setLayout(new BorderLayout(4, 4));
            this.getContentPane().add((Component)this.m_tabbedStepPanel, "Center");
            this.m_tabbedStepPanel.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_tabbedStepPanel != null) {
                this.m_tabbedStepPanel.destroy();
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

